IF OBJECT_ID(N'P_XIWA_PSellPHB_Btype') IS NOT NULL
    DROP PROCEDURE dbo.P_XIWA_PSellPHB_Btype
GO

CREATE PROCEDURE P_XIWA_PSellPHB_Btype
(
    @szPinPai NVARCHAR(60),
    @szPtypeId NVARCHAR(60),
    @szBtypeId NVARCHAR(60),
    @szEtypeId NVARCHAR(60),
    @szDtypeid NVARCHAR(60),
    @szKtypeId NVARCHAR(60),
    @szBeginDate NVARCHAR(25),
    @szEndDate NVARCHAR(25),
    @OperatorID NVARCHAR(50),
    @ShowAll BIT,
    @IsPaging INT = 0, --0Ϊ,1Ϊҳ
    @PageSize INT = 50, --ÿҳʾ
    @PageIndex INT = 0, --ڼҳ
    @PageFilter NVARCHAR(MAX) = '' ,
    @PageTotal INT = 0 OUTPUT 
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @Length INT

    IF @szBtypeId = '00000'
        SELECT @Length = 5
    ELSE
        SELECT @Length = LEN(@szBtypeId) + 5

    DECLARE @saletotal NUMERIC(38, 10)
    DECLARE @maolitotal NUMERIC(38, 10),@ShowAssistantQtyTotal BIT

    SELECT b.typeId, b.sonnum, b.UserCode, b.AreaTypeID, b.OrderNo
    INTO #TempBtype
    FROM dbo.GetUserHasRightsB(@OperatorID) b
    WHERE b.parid = @szBtypeId AND b.typeId <> '00000' AND b.isclient = 1
    
    SELECT BTypeID INTO #Brights FROM dbo.GetUserBrights(@OperatorID)
    SELECT KTypeID INTO #Krights FROM dbo.GetUserKrights(@OperatorID)
    SELECT DTypeID INTO #Drights FROM dbo.GetUserDrights(@OperatorID)
    SELECT PTypeID INTO #Prights FROM dbo.GetUserPrights(@OperatorID)
    
    Select s.btypeid,s.ktypeid,s.PtypeId,s.Vchcode,s.Draft,s.etypeid,n.VchType,n.DifAType,n.projectid,
		s.DetailSign,s.Qty,s.discounttotal,s.tax_total,s.costtotal,s.QtyOther,s.total
	Into #dlys
	From DlySale s
	INNER JOIN dbo.Dlyndx n ON s.Vchcode = n.Vchcode
	Where n.DATE >= @szBeginDate AND n.DATE <= @szEndDate AND s.Draft = 2
		 AND ( @szDtypeid = '%' OR n.projectid LIKE @szDtypeid )

    select n.btypeid, SUM(dlya.total) as total  
    INTO #ZoreTotalList
    from (
		SELECT distinct LEFT(s.btypeid, @Length) AS [btypeid],s.VchType,s.Vchcode,s.DifAType
           FROM #dlys s
               INNER JOIN #Krights k ON s.ktypeid = k.KTypeID
               INNER JOIN #Prights pr ON s.PtypeId = pr.PTypeID
               INNER JOIN #Brights b ON s.btypeid = b.BTypeID
               INNER JOIN #Drights d ON s.projectid = d.DTypeID
               LEFT JOIN dbo.ptype p ON p.typeId = s.PtypeId
           WHERE ( @szPinPai = '%' OR p.Brandtypeid LIKE @szPinPai )
               AND ( @szPtypeId = '%' OR s.PtypeId LIKE @szPtypeId ) AND ( @szEtypeId = '%' OR s.etypeid LIKE @szEtypeId )
               AND ( @szKtypeId = '%' OR s.ktypeid LIKE @szKtypeId )
      ) n 
      Left JOIN DifAtype ad on ad.Rec = n.DifAType 
      Left JOIN Dlya dlya on dlya.atypeid = ad.Atype and dlya.vchcode = n.Vchcode
      GROUP BY n.btypeid
    
    SELECT DS.btypeid, DS.QtyFact, DS.TotalFact, DS.Tax_TotalFact, DS.Qty, DS.Total, DS.Tax_Total, DS.Qtyback, DS.Totalback, DS.Tax_Totalback, DS.TaxTotal,
           DS.CostTotal, DS.QtyOther, DS.disTotal, DS.SaleZQTotal, DS.BackZQTotal, DS.SaleZQTotal - DS.BackZQTotal AS FactZQTotal,qtygift,costtotalgift,qtyothergift
    INTO #TempDlyBtypeNoZore
    FROM ( SELECT LEFT(s.btypeid, @Length) AS [btypeid],
				  SUM( case when s.DetailSign = 0 then ISNULL(-s.Qty, 0) else 0 end) AS QtyFact, 
				  SUM(ISNULL(-s.discounttotal, 0)) AS TotalFact,
                  SUM(ISNULL(-s.tax_total, 0)) AS Tax_TotalFact,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN case when s.DetailSign = 0 then ISNULL(-s.Qty, 0) else 0 end ELSE 0 END) AS Qty,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.discounttotal, 0)ELSE 0 END) AS Total,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.tax_total, 0)ELSE 0 END) AS Tax_Total,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN case when s.DetailSign = 0 then ISNULL(s.Qty, 0) else 0 end ELSE 0 END) AS Qtyback,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.discounttotal, 0)ELSE 0 END) AS Totalback,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.tax_total, 0)ELSE 0 END) AS Tax_Totalback,
                  SUM(ISNULL(-s.tax_total, 0)) - SUM(ISNULL(-s.discounttotal, 0)) AS TaxTotal,
                  SUM( case when s.DetailSign = 0 then ISNULL(-s.costtotal, 0) else 0 end) AS CostTotal,
                  SUM( case when s.DetailSign = 0 then ISNULL(-s.QtyOther, 0) else 0 end) AS QtyOther, --λ  
                  SUM(ISNULL(-s.total, 0)) - SUM(ISNULL(-s.discounttotal, 0)) AS disTotal, --ۿ۽  
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.total, 0)ELSE 0 END) AS SaleZQTotal,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.total, 0)ELSE 0 END) AS BackZQTotal,
                  SUM(CASE WHEN s.DetailSign = 1 THEN -s.[Qty] ELSE 0 END) AS qtygift,--Ʒ
				  SUM(CASE WHEN s.DetailSign = 1 THEN -s.[CostTotal] ELSE 0 END) AS costtotalgift,--Ʒɱ			  
				  SUM(CASE WHEN s.DetailSign = 1 THEN -s.QtyOther ELSE 0 END) AS qtyothergift--Ʒλ   
           FROM #dlys s
               INNER JOIN #Krights k ON s.ktypeid = k.KTypeID
               INNER JOIN #Prights pr ON s.PtypeId = pr.PTypeID
               INNER JOIN #Brights b ON s.btypeid = b.BTypeID
               INNER JOIN #Drights d ON s.projectid = d.DTypeID
               LEFT JOIN dbo.ptype p ON p.typeId = s.PtypeId
           WHERE ( @szPinPai = '%' OR p.Brandtypeid LIKE @szPinPai )
               AND ( @szPtypeId = '%' OR s.PtypeId LIKE @szPtypeId ) AND ( @szEtypeId = '%' OR s.etypeid LIKE @szEtypeId )
               AND ( @szKtypeId = '%' OR s.ktypeid LIKE @szKtypeId )
           GROUP BY LEFT(s.btypeid, @Length)) DS

	
	select tmpB.*,tmpZ.total as zoretotal
	INTO #TempDlyBtype
	from #TempDlyBtypeNoZore tmpB left join #ZoreTotalList tmpZ  on tmpB.btypeid = tmpZ.btypeid
	
    SELECT @saletotal = SUM(TotalFact), @maolitotal = SUM(TotalFact - CostTotal- costtotalgift)FROM #TempDlyBtype WHERE @szBtypeId = '00000' OR btypeid LIKE @szBtypeId + '%'    

    SELECT b.typeId AS bctypeid, b.UserCode, b.AreaTypeID AS rtypeid, b.sonnum, b.OrderNo AS [OrderNo], ISNULL(ds.QtyFact, 0) AS QtyFact,
           ISNULL(ds.TotalFact, 0) AS TotalFact, ISNULL(ds.Tax_TotalFact, 0) AS Tax_TotalFact, ISNULL(ds.Qty, 0) AS Qty, ISNULL(ds.Total, 0) AS Total,
           ISNULL(ds.Tax_Total, 0) AS Tax_Total, ISNULL(ds.Qtyback, 0) AS Qtyback, ISNULL(ds.Totalback, 0) AS Totalback,
           ISNULL(ds.Tax_Totalback, 0) AS Tax_Totalback,
           100 * ( CASE WHEN ISNULL(ds.Qty, 0) = 0 THEN 0 ELSE ISNULL(ds.Qtyback, 0) / ISNULL(ds.Qty, 0)END ) AS BackPercent,
           ISNULL(ds.TaxTotal, 0) AS TaxTotal, ISNULL(ds.CostTotal, 0) AS CostTotal, ISNULL(ds.QtyOther, 0) AS QtyOther,
           ISNULL(ds.TotalFact, 0) - ISNULL(ds.CostTotal, 0) - ISNULL(ds.costtotalgift,0) AS profittotal, --ë
           CASE WHEN @saletotal > 0 AND ISNULL(ds.TotalFact, 0) <> 0 THEN CAST(dbo.Divide(ISNULL(ds.TotalFact, 0) * 100, @saletotal) AS NUMERIC(38, 2))ELSE 0 END AS salerate, --۱  
           CASE WHEN @maolitotal > 0 AND ISNULL(ds.TotalFact, 0) <> ISNULL(ds.CostTotal, 0) THEN
                     CAST(dbo.Divide(( ISNULL(ds.TotalFact, 0) - ISNULL(ds.CostTotal, 0) - ISNULL(ds.costtotalgift,0)  ) * 100, @maolitotal) AS NUMERIC(38, 2))
           ELSE 0 END AS maolirate, --ëױ  
           ISNULL(ds.SaleZQTotal, 0) AS SaleZQTotal, ISNULL(ds.BackZQTotal, 0) AS BackZQTotal, ISNULL(ds.FactZQTotal, 0) AS FactZQTotal,
           CAST(dbo.Divide(( ds.Totalfact - ds.CostTotal- ds.costtotalgift ) * 100, ds.Totalfact) AS NUMERIC(38, 2)) AS rate, --ë
           dbo.Divide(ds.Totalfact, ds.Qtyfact) AS factprice,
           dbo.Divide(ds.Tax_Totalfact, ds.Qtyfact) AS facttaxprice,
           dbo.Divide(ds.SaleZQTotal, ds.Qty) AS SaleZQPrice,
           dbo.Divide(ds.Total, ds.Qty) AS saleprice, --ƽ۵
           dbo.Divide(ds.Tax_Total, ds.Qty) AS taxprice, --ƽ˰
           dbo.Divide(ds.BackZQTotal, ds.Qtyback) AS BackZQPrice,
           dbo.Divide(ds.Totalback, ds.Qtyback) AS backprice, --ƽ˻	
           dbo.Divide(ds.Tax_Totalback, ds.Qtyback) AS backtaxprice, --ƽ˻˰
           dbo.Divide(ds.FactZQTotal, ds.Qtyfact) AS FactZQPrice,
           dbo.Divide(ds.CostTotal, ds.Qtyfact) AS costprice, --ƽɱ
           dbo.Divide((ds.Totalfact - ds.CostTotal - ds.costtotalgift),(ds.qtygift+ds.Qtyfact)) as maoli,
           ds.qtygift,ds.costtotalgift,ds.qtyothergift,
           ds.zoretotal
    INTO #temp
    FROM #TempBtype b
        LEFT JOIN #TempDlyBtype ds ON b.typeId = ds.btypeid
    WHERE ( @ShowAll = 1
              OR ( ds.[Qty] <> 0 OR ds.[Total] <> 0 OR ds.[Tax_Total] <> 0 OR ds.[TaxTotal] <> 0 OR ds.[CostTotal] <> 0 OR ds.[QtyOther] <> 0
                     OR ds.[Qtyback] <> 0 OR ds.[Totalback] <> 0 OR ds.[Tax_Totalback] <> 0 OR ds.[QtyFact] <> 0 OR ds.[TotalFact] <> 0
                     OR ds.[Tax_TotalFact] <> 0 OR ds.SaleZQTotal <> 0 OR ds.BackZQTotal <> 0 OR ds.FactZQTotal <> 0 or ds.qtygift <> 0 
                     or ds.qtyothergift <> 0 or ds.costtotalgift <> 0 or ds.zoretotal <> 0 ))
    IF @IsPaging = 1
        EXEC dbo.P_XIWA_ToPage '#Temp', @PageSize, @PageIndex, @PageFilter, @PageTotal OUTPUT, 'Usercode,Bctypeid','qty;qtyother;total;tax_total;costtotal;taxtotal;profittotal;qtyback;totalback;tax_totalback;qtyfact;totalfact;tax_totalfact;SaleZQTotal;BackZQTotal;FactZQTotal;qtygift;costtotalgift;qtyothergift;rate;zoretotal;'
    ELSE
        SELECT *
        FROM #temp
        ORDER BY UserCode, bctypeid
        
    DROP TABLE #ZoreTotalList
END
GO