IF OBJECT_ID(N'P_XIWA_PSellPHB_Ptype') IS NOT NULL
    DROP PROCEDURE dbo.P_XIWA_PSellPHB_Ptype
GO

CREATE PROCEDURE P_XIWA_PSellPHB_Ptype
(
    @szPinPai NVARCHAR(60),
    @szPtypeId NVARCHAR(60),
    @szBtypeId NVARCHAR(60),
    @szEtypeId NVARCHAR(60),
    @szDtypeid NVARCHAR(60),
    @szKtypeId NVARCHAR(60),
    @szBeginDate NVARCHAR(25),
    @szEndDate NVARCHAR(25),
    @OperatorID NVARCHAR(50),
    @ShowAll BIT,
    @IsPaging INT = 0, --0Ϊ,1Ϊҳ
    @PageSize INT = 50, --ÿҳʾ
    @PageIndex INT = 0, --ڼҳ
    @PageFilter NVARCHAR(MAX) = '' ,
    @PageTotal INT = 0 OUTPUT 
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @Length INT

    IF @szPtypeId = '00000'
        SELECT @Length = 5
    ELSE
        SELECT @Length = LEN(@szPtypeId) + 5

    SELECT typeId, UserCode, UnitRate1, UnitRate2, sonnum, Unit1, Unit2, Unit3, OrderNo
    INTO #TempPtype
    FROM dbo.GetUserHasRightsP(@OperatorID)
    WHERE [ParId] = @szPtypeId AND [typeId] <> '00000'

    -- Ȩ
    SELECT BTypeID INTO #Brights FROM dbo.GetUserBrights(@OperatorID)
    SELECT KTypeID INTO #Krights FROM dbo.GetUserKrights(@OperatorID)
    SELECT DTypeID INTO #Drights FROM dbo.GetUserDrights(@OperatorID)
    SELECT PTypeID INTO #Prights FROM dbo.GetUserPrights(@OperatorID)

	Select CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END As VchType,
		s.PtypeId,s.DetailSign,s.Qty,s.discounttotal,s.tax_total,s.costtotal,s.QtyOther,s.total,s.ktypeid,n.btypeid,n.projectid,s.etypeid
	Into #dlyndx
	FROM dbo.DlySale s
	INNER JOIN dbo.Dlyndx n ON s.Vchcode = n.Vchcode
	WHERE n.DATE >= @szBeginDate AND n.DATE <= @szEndDate AND s.Draft = 2

    SELECT DS.Ptypeid, DS.QtyFact, DS.TotalFact, DS.Tax_TotalFact, DS.Qty, DS.Total, DS.Tax_Total, DS.Qtyback, DS.Totalback, DS.Tax_Totalback, DS.TaxTotal,
           DS.CostTotal, DS.QtyOther, DS.disTotal, DS.SaleZQTotal, DS.BackZQTotal, DS.SaleZQTotal - DS.BackZQTotal AS FactZQTotal,qtygift,costtotalgift,qtyothergift
    INTO #TempDlyPtype
    FROM ( SELECT LEFT(s.PtypeId, @Length) AS [Ptypeid], 
				  SUM(case when s.DetailSign = 0 then -s.Qty else 0 end) AS QtyFact,
				  SUM(-s.discounttotal) AS TotalFact, 
				  SUM(-s.tax_total) AS Tax_TotalFact,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL( case when s.DetailSign = 0 then -s.Qty else 0 end, 0)ELSE 0 END) AS Qty,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL( -s.discounttotal, 0)ELSE 0 END) AS Total,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL( -s.tax_total, 0)ELSE 0 END) AS Tax_Total,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL( case when s.DetailSign =0 then s.Qty else 0 end, 0)ELSE 0 END) AS Qtyback,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.discounttotal, 0)ELSE 0 END) AS Totalback,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.tax_total, 0)ELSE 0 END) AS Tax_Totalback,
                  -SUM(s.tax_total) + SUM( s.discounttotal) AS TaxTotal, 
                  SUM(case when s.DetailSign = 0 then ISNULL(-s.costtotal, 0) else 0 end) AS CostTotal,
                  SUM(case when s.DetailSign = 0 then ISNULL(-s.QtyOther, 0) else 0 end ) AS QtyOther, --λ
                  -SUM(s.total - s.discounttotal) AS disTotal, --ۿ۽     
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.total, 0)ELSE 0 END) AS SaleZQTotal,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.total, 0)ELSE 0 END) AS BackZQTotal,
                  SUM(CASE WHEN s.DetailSign = 1 THEN -s.[Qty] ELSE 0 END) AS qtygift,--Ʒ
				  SUM(CASE WHEN s.DetailSign = 1 THEN -s.[CostTotal] ELSE 0 END) AS costtotalgift,--Ʒɱ			  
				  SUM(CASE WHEN s.DetailSign = 1 THEN -s.QtyOther ELSE 0 END) AS qtyothergift--Ʒλ
           FROM #dlyndx s
               INNER JOIN #Krights k ON s.ktypeid = k.KTypeID
               INNER JOIN #Prights pr ON s.PtypeId = pr.PTypeID
               INNER JOIN #Brights b ON s.btypeid = b.BTypeID
               INNER JOIN #Drights d ON s.projectid = d.DTypeID
               LEFT JOIN dbo.ptype p ON p.typeId = s.PtypeId
           WHERE ( @szPinPai = '%' OR p.Brandtypeid LIKE @szPinPai )
               AND ( @szBtypeId = '%' OR s.btypeid LIKE @szBtypeId ) AND ( @szEtypeId = '%' OR s.etypeid LIKE @szEtypeId )
               AND ( @szKtypeId = '%' OR s.ktypeid LIKE @szKtypeId ) AND ( @szDtypeid = '%' OR s.projectid LIKE @szDtypeid )
           GROUP BY LEFT(s.PtypeId, @Length)) DS
    
    DECLARE @saletotal NUMERIC(38, 10), @maolitotal NUMERIC(38, 10), @ShowAssistantQtyTotal BIT
    SELECT @saletotal = SUM(TotalFact), @maolitotal = SUM(TotalFact - CostTotal- costtotalgift)FROM #TempDlyPtype WHERE @szPtypeId = '00000' OR Ptypeid LIKE @szPtypeId + '%'
    SELECT @saletotal = ISNULL(@saletotal, 0), @maolitotal = ISNULL(@maolitotal, 0), @ShowAssistantQtyTotal = dbo.CheckAssistantQtyTotal()

    SELECT P.typeId AS ptypeid, P.UserCode, P.UnitRate1, P.Qty, P.Total, P.Tax_Total, P.Totalback, P.Qtyback, P.Tax_Totalback, P.Totalfact, P.Qtyfact,
           P.Tax_Totalfact, P.TaxTotal, P.CostTotal, P.QtyOther,
           CAST(dbo.Divide(( P.Totalfact - P.CostTotal - P.costtotalgift ) * 100, P.Totalfact) AS NUMERIC(38, 2)) AS rate, --ë  
           CASE WHEN @ShowAssistantQtyTotal = 1 THEN CAST(dbo.Divide(P.Qtyfact , P.UnitRate1) AS NUMERIC(38, 4))
           ELSE      CASE WHEN P.UnitRate1 = 1 THEN 0 ELSE CAST(dbo.Divide(P.Qtyfact, P.UnitRate1) AS NUMERIC(38, 4))END
           END AS fzQty1, 
           CASE WHEN @ShowAssistantQtyTotal = 1 THEN CAST(dbo.Divide(P.Qtyfact , P.UnitRate2) AS NUMERIC(38, 4))
                          ELSE      CASE WHEN P.UnitRate2 = 1 THEN 0 ELSE CAST(dbo.Divide(P.Qtyfact, P.UnitRate2) AS NUMERIC(38, 4))END
                          END AS fzQty2, --
           dbo.fn_GetAssistantQtyNew(P.Qtyfact, P.Unit1, P.Unit2, P.Unit3, P.UnitRate1, P.UnitRate2) AS fzqty, --2
           dbo.Divide(P.Total, P.Qty) AS saleprice, --ƽ۵
           dbo.Divide(P.Tax_Total, P.Qty) AS taxprice, --ƽ˰
           dbo.Divide(P.Totalback, P.Qtyback) AS backprice, --ƽ˻			
           dbo.Divide(P.Tax_Totalback, P.Qtyback) AS backtaxprice, --ƽ˻˰
           100 * ( CASE WHEN P.Qty = 0 THEN 0 ELSE P.Qtyback / P.Qty END ) AS backpercent, 
           dbo.Divide(P.Totalfact, P.Qtyfact) AS factprice,
           dbo.Divide(P.Tax_Totalfact, P.Qtyfact) AS facttaxprice, 
           dbo.Divide(P.CostTotal, P.Qtyfact) AS costprice, --ƽɱ
           ( P.Totalfact - P.CostTotal - p.costtotalgift ) AS profittotal, --ë
           --( dbo.Divide(P.Totalfact, P.Qtyfact) - dbo.Divide(P.CostTotal, P.Qtyfact)) AS maoli, --λë
           dbo.Divide(( P.Totalfact - P.CostTotal - p.costtotalgift),(p.qtygift+p.Qtyfact)) as maoli,
           P.disTotal,
           CASE WHEN @saletotal > 0 AND P.Totalfact <> 0 THEN CAST(dbo.Divide(( P.Totalfact ) * 100, @saletotal) AS NUMERIC(38, 2))ELSE 0 END AS salerate, --۱  
           CASE WHEN @maolitotal > 0 AND P.Totalfact <> P.CostTotal THEN CAST(dbo.Divide(( P.Totalfact - P.CostTotal - p.costtotalgift ) * 100, @maolitotal) AS NUMERIC(38, 2))ELSE
                     0 END AS maolirate, --ëױ    
           P.sonnum, 
           P.SaleZQTotal, 
           dbo.Divide(P.SaleZQTotal, P.Qty) AS SaleZQPrice, 
           P.BackZQTotal, 
           dbo.Divide(P.BackZQTotal, P.Qtyback) AS BackZQPrice,
           P.FactZQTotal, 
           dbo.Divide(P.FactZQTotal, P.Qtyfact) AS FactZQPrice,
           p.qtygift,p.costtotalgift,p.qtyothergift,
           CASE WHEN @ShowAssistantQtyTotal = 1 THEN CAST(dbo.Divide(P.qtygift ,P.UnitRate1) AS NUMERIC(38, 4))
           ELSE      CASE WHEN P.UnitRate1 = 1 THEN 0 ELSE CAST(dbo.Divide(P.qtygift, P.UnitRate1) AS NUMERIC(38, 4))END
           END AS fzqty1gift,  --Ʒ1 
           CASE WHEN @ShowAssistantQtyTotal = 1 THEN CAST(P.qtygift / P.UnitRate2 AS NUMERIC(38, 4))
                          ELSE      CASE WHEN P.UnitRate2 = 1 THEN 0 ELSE CAST(dbo.Divide(P.qtygift , P.UnitRate2) AS NUMERIC(38, 4))END
                          END AS fzqty2gift, --Ʒ1
           dbo.fn_GetAssistantQtyNew(P.qtygift, P.Unit1, P.Unit2, P.Unit3, P.UnitRate1, P.UnitRate2) AS fzqtygift --Ʒ
    INTO #Temp0
    FROM ( SELECT P.typeId, P.UserCode, P.UnitRate1, P.UnitRate2, P.sonnum, P.Unit1, P.Unit2, P.Unit3, ISNULL(P.OrderNo, 0) AS [OrderNo],
                  ISNULL(ds.QtyFact, 0) AS Qtyfact, ISNULL(ds.TotalFact, 0) AS Totalfact, ISNULL(ds.Tax_TotalFact, 0) AS Tax_Totalfact,
                  ISNULL(ds.Qty, 0) AS Qty, ISNULL(ds.Total, 0) AS Total, ISNULL(ds.Tax_Total, 0) AS Tax_Total, ISNULL(ds.Qtyback, 0) AS Qtyback,
                  ISNULL(ds.Totalback, 0) AS Totalback, ISNULL(ds.Tax_Totalback, 0) AS Tax_Totalback, ISNULL(ds.TaxTotal, 0) AS TaxTotal,
                  ISNULL(ds.CostTotal, 0) AS CostTotal, ISNULL(ds.QtyOther, 0) AS QtyOther, ISNULL(ds.disTotal, 0) AS disTotal,
                  ISNULL(ds.SaleZQTotal, 0) AS SaleZQTotal, ISNULL(ds.BackZQTotal, 0) AS BackZQTotal, ISNULL(ds.FactZQTotal, 0) AS FactZQTotal,
                  ISNULL(ds.qtygift,0) as qtygift,ISNULL(ds.costtotalgift,0) as costtotalgift , isnull(ds.qtyothergift,0) as qtyothergift
           FROM #TempPtype P
               LEFT JOIN #TempDlyPtype ds ON P.typeId = ds.Ptypeid ) P
    WHERE ( @ShowAll = 1
              OR ( P.Qty <> 0 OR P.Total <> 0 OR P.TaxTotal <> 0 OR P.Tax_Total <> 0 OR P.CostTotal <> 0 OR P.QtyOther <> 0 OR P.Qtyfact <> 0
                     OR P.Totalfact <> 0 OR P.Tax_Totalfact <> 0 OR P.Qtyback <> 0 OR P.Totalback <> 0 OR P.Tax_Totalback <> 0 OR P.SaleZQTotal <> 0
                     OR P.BackZQTotal <> 0 OR P.FactZQTotal <> 0 or p.qtygift <> 0 or p.qtyothergift <> 0 or p.costtotalgift <> 0 ))

    IF @IsPaging = 1
        EXEC dbo.P_XIWA_ToPage '#Temp0', @PageSize, @PageIndex, @PageFilter, @PageTotal OUTPUT, 'Usercode,PTypeid',
                               'qty;fzqty1;fzqty2;qtyother;total;tax_total;costtotal;taxtotal;profittotal;rate;qtyback;totalback;tax_totalback;qtyfact;totalfact;tax_totalfact;SaleZQTotal;BackZQTotal;FactZQTotal;qtygift;costtotalgift;qtyothergift;fzqty1gift;fzqty2gift;'
    ELSE
        SELECT ptypeid, UserCode, UnitRate1, Qty, Total, Tax_Total, Totalback, Qtyback, Tax_Totalback, Totalfact, Qtyfact, Tax_Totalfact, TaxTotal, CostTotal,
               QtyOther, rate, fzQty1, fzQty2, fzqty, saleprice, taxprice, backprice, backtaxprice, backpercent, factprice, facttaxprice, costprice,
               profittotal, maoli, disTotal, salerate, maolirate, sonnum, SaleZQTotal, SaleZQPrice, BackZQTotal, BackZQPrice, FactZQTotal, FactZQPrice,qtygift,costtotalgift,qtyothergift,fzqty1gift,fzqty2gift,fzqtygift
        FROM #Temp0
        ORDER BY UserCode, ptypeid
END
GO