IF EXISTS ( SELECT  *
            FROM    dbo.sysobjects
            WHERE   id = OBJECT_ID(N'[dbo].[p_XIWA_GetAreaSaleStat]')
                    AND OBJECTPROPERTY(id, N'IsProcedure') = 1 )
  DROP PROCEDURE [dbo].[p_XIWA_GetAreaSaleStat]
GO

/*==============================================================================
 | p_XIWA_GetAreaSaleStat
 |̹ õ״ͳ
 |------------------------------------------------------------------------------
 | ӥ
 |ʱ 2004-01-07
 |------------------------------------------------------------------------------
 |˵                         ˵               		
 |	    @cMode	   nVarchar(1)	   ѯģʽ			    IN
 |	    @lMode	   INT  	   ѯ			    IN
 |					   0
 |					   1Ϊ
 |	    @cZTypeID	   nVarchar(25) 	   ID			    IN
 |          @szptypeid     nVarchar(50)     ƷID                           IN  
 |	    @szBEGINDate   nVarchar(10)     ʼʱ			    IN
 |	    @szEndDat      nVarchar(10)     ʱ		    	    IN
 |          @OperatorID    nVarchar(25)     ԱID              	    IN
 |------------------------------------------------------------------------------
 |ֵ˵ֵ		
 |           -------------------------------------------------------------------
 |		0  		ɹ
 |		-2106 		û
 |------------------------------------------------------------------------------
 |޸  
 |޸ 2008-8-8
 |޸ Ʒ
 ================================================================================
*/
CREATE  PROCEDURE [dbo].[p_XIWA_GetAreaSaleStat]
(   
  @cMode NVARCHAR(1) ,
  @lMode INT ,
  @cZTypeID NVARCHAR(25) ,
  @szptypeid NVARCHAR(50) ,
  @szBEGINDate NVARCHAR(25) ,
  @szEndDate NVARCHAR(25) ,
  @szEtypeid NVARCHAR(60),   -- add V21 ysj
  @szKtypeid NVARCHAR(60),  -- add V21 ysj
  @szBrandTypeid NVARCHAR(60),  -- add V21 ysj
  @OperatorID NVARCHAR(25) ,
  @ShowAll BIT ,
  @IsPaging INT = 0 ,--0Ϊ,1Ϊҳ
  @PageSize INT = 50 ,--ÿҳʾ
  @PageIndex INT = 0 ,--ڼҳ
  @PageFilter NVARCHAR(MAX) = '' ,
  @PageTotal INT = 0 OUTPUT      
 )
AS
  SET NOCOUNT ON
DECLARE @Len INT  
DECLARE @Parid NVARCHAR(100)
              
IF ( @szptypeid = '' ) OR ( @szptypeid = '00000' )
  SELECT  @szptypeid = '%'   
ELSE
  SELECT  @szptypeid = @szptypeid + '%'  
  
IF ( @szEtypeid = '' ) OR ( @szEtypeid = '00000' )
  SELECT  @szEtypeid = '%'   
ELSE
  SELECT  @szEtypeid = @szEtypeid + '%'  
  
IF ( @szKtypeid = '' ) OR ( @szKtypeid = '00000' )
  SELECT  @szKtypeid = '%'   
ELSE
  SELECT  @szKtypeid = @szKtypeid + '%'  
  
IF ( @szBrandTypeid = '' ) OR ( @szBrandTypeid = '00000' )
  SELECT  @szBrandTypeid = '%'   
ELSE
  SELECT  @szBrandTypeid = @szBrandTypeid + '%'  
        
        
EXEC dbo.p_XIWA_GetAreaSaleStat_Query @cMode = @cMode, -- nvarchar(1)
  @lMode = @lMode, -- int
  @cZTypeID = @cZTypeID, -- nvarchar(25)
  @szptypeid = @szptypeid, -- nvarchar(50)
  @szBEGINDate = @szBEGINDate, -- nvarchar(25)
  @szEndDate = @szEndDate, -- nvarchar(25)
  @szEtypeid = @szEtypeid,   -- add V21 ysj
  @szKtypeid = @szKtypeid,  -- add V21 ysj
  @szBrandTypeid = @szBrandTypeid,  -- add V21 ysj
  @OperatorID = @OperatorID, -- nvarchar(25)
  @ShowAll = @ShowAll, 
  @IsPaging = @IsPaging,--0Ϊ,1Ϊҳ
  @PageSize = @PageSize,--ÿҳʾ
  @PageIndex = @PageIndex, @PageFilter = @PageFilter,--ڼҳ
  @PageTotal = @PageTotal OUTPUT, @Len = @Len, @Parid = @Parid
GO
        
IF EXISTS ( SELECT  *
            FROM    dbo.sysobjects
            WHERE   id = OBJECT_ID(N'[dbo].[p_XIWA_GetAreaSaleStat_Query]')
                    AND OBJECTPROPERTY(id, N'IsProcedure') = 1 )
  DROP PROCEDURE [dbo].[p_XIWA_GetAreaSaleStat_Query]
GO
  
CREATE  PROCEDURE [dbo].[p_XIWA_GetAreaSaleStat_Query]
(
  @cMode NVARCHAR(1) ,
  @lMode INT ,
  @cZTypeID NVARCHAR(25) ,
  @szptypeid NVARCHAR(50) ,
  @szBEGINDate NVARCHAR(25) ,
  @szEndDate NVARCHAR(25) ,
  @szEtypeid NVARCHAR(60),   -- add V21 ysj
  @szKtypeid NVARCHAR(60),  -- add V21 ysj
  @szBrandTypeid NVARCHAR(60),  -- add V21 ysj
  @OperatorID NVARCHAR(25) ,
  @ShowAll BIT ,
  @IsPaging INT = 0 ,--0Ϊ,1Ϊҳ
  @PageSize INT = 50 ,--ÿҳʾ
  @PageIndex INT = 0 ,--ڼҳ
  @PageFilter NVARCHAR(MAX) = '' ,
  @PageTotal INT = 0 OUTPUT  ,
  @Len INT ,
  @Parid NVARCHAR(100)
)
AS
  SET NOCOUNT ON
IF @lMode = 0
  BEGIN
    IF @cMode = 'G'
      BEGIN  
        Exec P_XIWA_PSellPHB_AreaType @cMode = @cMode, -- nvarchar(1)
		  @lMode = @lMode, -- int
		  @cZTypeID = @cZTypeID, -- nvarchar(25)
		  @szptypeid = @szptypeid, -- nvarchar(50)
		  @szBEGINDate = @szBEGINDate, -- nvarchar(25)
		  @szEndDate = @szEndDate, -- nvarchar(25)
		  @szEtypeid = @szEtypeid,   -- add V21 ysj
		  @szKtypeid = @szKtypeid,  -- add V21 ysj
		  @szBrandTypeid = @szBrandTypeid,  -- add V21 ysj
		  @OperatorID = @OperatorID, -- nvarchar(25)
		  @ShowAll = @ShowAll, @IsPaging = @IsPaging,--0Ϊ,1Ϊҳ
		  @PageSize = @PageSize,--ÿҳʾ
		  @PageIndex = @PageIndex, @PageFilter = @PageFilter,--ڼҳ
		  @PageTotal = @PageTotal OUTPUT
      END  
    --۱ͻۻܣ  
    ELSE
      IF @cMode = 'L'
        BEGIN  
          exec  P_XIWA_PSellPHB_AreaType_Ctype @cMode = @cMode, -- nvarchar(1)
		  @lMode = @lMode, -- int
		  @cZTypeID = @cZTypeID, -- nvarchar(25)
		  @szptypeid = @szptypeid, -- nvarchar(50)
		  @szBEGINDate = @szBEGINDate, -- nvarchar(25)
		  @szEndDate = @szEndDate, -- nvarchar(25)
		  @szEtypeid = @szEtypeid,   -- add V21 ysj
		  @szKtypeid = @szKtypeid,  -- add V21 ysj
		  @szBrandTypeid = @szBrandTypeid,  -- add V21 ysj
		  @OperatorID = @OperatorID, -- nvarchar(25)
		  @ShowAll = @ShowAll, @IsPaging = @IsPaging,--0Ϊ,1Ϊҳ
		  @PageSize = @PageSize,--ÿҳʾ
		  @PageIndex = @PageIndex, @PageFilter = @PageFilter,--ڼҳ
		  @PageTotal = @PageTotal OUTPUT     
        END  
  END
ELSE
  BEGIN  
      exec P_XIWA_PSellPHBList_AreaType @cMode = @cMode, -- nvarchar(1)
		  @lMode = @lMode, -- int
		  @cZTypeID = @cZTypeID, -- nvarchar(25)
		  @szptypeid = @szptypeid, -- nvarchar(50)
		  @szBEGINDate = @szBEGINDate, -- nvarchar(25)
		  @szEndDate = @szEndDate, -- nvarchar(25)
		  @szEtypeid = @szEtypeid,   -- add V21 ysj
		  @szKtypeid = @szKtypeid,  -- add V21 ysj
		  @szBrandTypeid = @szBrandTypeid,  -- add V21 ysj
		  @OperatorID = @OperatorID, -- nvarchar(25)
		  @ShowAll = @ShowAll, @IsPaging = @IsPaging,--0Ϊ,1Ϊҳ
		  @PageSize = @PageSize,--ÿҳʾ
		  @PageIndex = @PageIndex, @PageFilter = @PageFilter,--ڼҳ
		  @PageTotal = @PageTotal OUTPUT
	  
  END    
IF @@ROWCOUNT = 0
  GOTO error102  
ELSE
  BEGIN
    GOTO succee  
  END
succee:  
RETURN 0  
error102:  
RETURN -2106  

GO


IF EXISTS ( SELECT  *
            FROM    dbo.sysobjects
            WHERE   id = OBJECT_ID(N'[dbo].[P_XIWA_PSellPHB_AreaType]')
                    AND OBJECTPROPERTY(id, N'IsProcedure') = 1 )
  DROP PROCEDURE P_XIWA_PSellPHB_AreaType
GO
CREATE  PROCEDURE P_XIWA_PSellPHB_AreaType
(   
  @cMode NVARCHAR(1) ,
  @lMode INT ,
  @cZTypeID NVARCHAR(25) ,
  @szptypeid NVARCHAR(50) ,
  @szBEGINDate NVARCHAR(25) ,
  @szEndDate NVARCHAR(25) ,
  @szEtypeid NVARCHAR(60),   -- add V21 ysj
  @szKtypeid NVARCHAR(60),  -- add V21 ysj
  @szBrandTypeid NVARCHAR(60),  -- add V21 ysj
  @OperatorID NVARCHAR(25) ,
  @ShowAll BIT ,
  @IsPaging INT = 0 ,--0Ϊ,1Ϊҳ
  @PageSize INT = 50 ,--ÿҳʾ
  @PageIndex INT = 0 ,--ڼҳ
  @PageFilter NVARCHAR(MAX) = '' ,
  @PageTotal INT = 0 OUTPUT      
 )As
 begin
	SET NOCOUNT ON
	DECLARE @Len INT  
	DECLARE @Parid NVARCHAR(100) 
	DECLARE @saletotal NUMERIC(38, 10)
	DECLARE @maolitotal NUMERIC(38, 10)
	IF ( @cZTypeID = '' )
		SELECT  @Parid = '00000'
	ELSE
		  SELECT  @Parid = @cZTypeID
	IF ( @cZTypeID = '' )
		  OR ( @cZTypeID = '00000' )
		  BEGIN  
			SELECT  @Len = 5  
			SELECT  @cZTypeID = '%'  
		  END
	ELSE
	  BEGIN  
		SELECT  @Len = LEN(@cZTypeID) + 5  
		SELECT  @cZTypeID = @cZTypeID + '%'     
	  END 
	  
	SELECT  [TypeID], [SonNum], UserCode, FullName, OrderNo
	INTO    #AreaType
	FROM    dbo.AreaType
	WHERE   [ParID] = @Parid
			AND [TypeID] <> '00000'
                    
	IF @Parid = '00000'
	  INSERT  INTO #AreaType
	  VALUES  ( '', 0, '', '', 99999 )	
	 
	  
	SELECT  PTypeID INTO  #PTypeID FROM dbo.GetUserPrights(@OperatorID)
	SELECT  BTypeID INTO  #BTypeID FROM dbo.GetUserBrights(@OperatorID)
	SELECT  KTypeID INTO  #KTypeID FROM  dbo.GetUserKrights(@OperatorID)
	SELECT  DTypeID INTO  #DTypeID FROM  dbo.GetUserDrights(@OperatorID)
	
	Select s.Vchcode,s.DetailSign,s.btypeid,s.discounttotal,s.Qty,s.tax_total,s.Vchtype,s.total,s.costtotal,s.QtyOther,s.PtypeId,s.ktypeid,n.projectid,s.etypeid,
		n.DifAType
	Into #dlys
	FROM    DlySale s
	INNER JOIN Dlyndx n ON  s.Vchcode = n.Vchcode
	WHERE   n.[DATE] >= @szBEGINDate  AND n.[DATE] <= @szEndDate
				   AND n.draft = 2

   SELECT DS.btypeid, DS.QtyFact, DS.TotalFact, DS.Tax_TotalFact, DS.Qty, DS.Total, DS.Tax_Total, DS.Qtyback, DS.Totalback, DS.Tax_Totalback, DS.TaxTotal,
           DS.disTotal, DS.CostTotal, DS.qtyother, DS.SaleZQTotal, DS.BackZQTotal, DS.SaleZQTotal - DS.BackZQTotal AS FactZQTotal,qtygift,costtotalgift,qtyothergift
    INTO #TempDlyBtype
    FROM ( SELECT s.btypeid, 
				  SUM(case when s.DetailSign = 0 then ISNULL(-s.Qty, 0) else 0 end) AS QtyFact, 
				  SUM(ISNULL(-s.discounttotal, 0)) AS TotalFact,
                  SUM(ISNULL(-s.tax_total, 0)) AS Tax_TotalFact,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN case when s.DetailSign = 0 then ISNULL(-s.Qty, 0) else 0 end ELSE 0 END) AS Qty,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.discounttotal, 0)ELSE 0 END) AS Total,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.tax_total, 0)ELSE 0 END) AS Tax_Total,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN case when s.DetailSign = 0 then ISNULL(s.Qty, 0) else 0 end ELSE 0 END) AS Qtyback,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.discounttotal, 0)ELSE 0 END) AS Totalback,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.tax_total, 0)ELSE 0 END) AS Tax_Totalback,
                  SUM(ISNULL(-s.tax_total, 0)) - SUM(ISNULL(-s.discounttotal, 0)) AS TaxTotal,
                  SUM(ISNULL(-s.total, 0)) - SUM(ISNULL(-s.discounttotal, 0)) AS disTotal, --ۿ۽
                  SUM(case when s.DetailSign = 0 then ISNULL(-s.costtotal, 0) else 0 end ) AS CostTotal, 
                  SUM(case when s.DetailSign = 0 then ISNULL(-s.QtyOther, 0) else 0 end) AS qtyother,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.total, 0)ELSE 0 END) AS SaleZQTotal,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.total, 0)ELSE 0 END) AS BackZQTotal,
                  SUM(CASE WHEN s.DetailSign = 1 THEN -s.[Qty] ELSE 0 END) AS qtygift,--Ʒ
				  SUM(CASE WHEN s.DetailSign = 1 THEN -s.[CostTotal] ELSE 0 END) AS costtotalgift,--Ʒɱ			  
				  SUM(CASE WHEN s.DetailSign = 1 THEN -s.QtyOther ELSE 0 END) AS qtyothergift--Ʒλ
           FROM    #dlys s
					INNER JOIN #PTypeID pr ON s.PtypeId = pr.PTypeID
					INNER JOIN #BTypeID br ON s.btypeid = br.BTypeID
					INNER JOIN #KTypeID kr ON s.ktypeid = kr.KTypeID
					INNER JOIN #DTypeID dr ON s.projectid = dr.DTypeID
					left JOIN ptype p on s.PtypeId = p.typeId
           WHERE   ( @szptypeid = '%' OR s.PtypeId LIKE @szptypeid)
				   AND ( @szEtypeid = '%' OR s.etypeid LIKE @szEtypeid)
				   AND ( @szKtypeid = '%' OR s.ktypeid LIKE @szKtypeid)
				   AND ( @szBrandTypeid = '%' OR p.Brandtypeid LIKE @szBrandTypeid)
           GROUP BY s.btypeid) DS

		SELECT  LEFT(b.AreaTypeID, @Len) AS areatypeid, 
				SUM(DS.QtyFact) as QtyFact,  SUM(DS.TotalFact) as TotalFact, SUM(DS.Tax_TotalFact) as Tax_TotalFact, 
				SUM(DS.Qty) as Qty, SUM(DS.Total) as Total, SUM(DS.Tax_Total) as Tax_Total, SUM(DS.Qtyback) as Qtyback, 
				SUM(DS.Totalback) as Totalback, SUM(DS.Tax_Totalback) as Tax_Totalback, SUM(DS.TaxTotal) as TaxTotal,
                SUM(DS.disTotal) as disTotal, SUM(DS.CostTotal) as CostTotal, SUM(DS.qtyother) AS qtyother, 
                SUM(DS.SaleZQTotal) as SaleZQTotal, SUM(DS.BackZQTotal) AS BackZQTotal, SUM(DS.FactZQTotal) AS FactZQTotal,
                SUM(ds.qtygift) as qtygift,
                SUM(ds.costtotalgift) as costtotalgift,
                SUM(ds.qtyothergift) as qtyothergift
        INTO    #TempDlyAreaNoZore
        FROM    Btype b
        INNER JOIN #BTypeID br ON  b.typeId = br.BTypeID
        LEFT JOIN #TempDlyBtype ds ON b.[typeId] = ds.[btypeid]
        WHERE   b.[typeId] <> '00000'
                AND b.[isclient] = 1
                AND b.sonnum = 0
        GROUP BY LEFT(b.AreaTypeID, @Len)
              
        
		select n.areatypeid, SUM(dlya.total) as total  
		INTO #ZoreTotalList
		from (
			SELECT distinct LEFT(b.AreaTypeID, @Len) AS areatypeid,ds.Vchcode,ds.DifAType
			   FROM Btype b
					INNER JOIN #BTypeID br ON  b.typeId = br.BTypeID
					LEFT JOIN (
						SELECT s.btypeid,s.Vchcode,s.DifAType
						   FROM    #dlys s
									INNER JOIN #PTypeID pr ON s.PtypeId = pr.PTypeID
									INNER JOIN #BTypeID br ON s.btypeid = br.BTypeID
									INNER JOIN #KTypeID kr ON s.ktypeid = kr.KTypeID
									INNER JOIN #DTypeID dr ON s.projectid = dr.DTypeID
									left JOIN ptype p on s.PtypeId = p.typeId
						   WHERE   ( @szptypeid = '%' OR s.PtypeId LIKE @szptypeid)
								   AND ( @szEtypeid = '%' OR s.etypeid LIKE @szEtypeid)
								   AND ( @szKtypeid = '%' OR s.ktypeid LIKE @szKtypeid)
								   AND ( @szBrandTypeid = '%' OR p.Brandtypeid LIKE @szBrandTypeid)
					
					) ds ON b.[typeId] = ds.[btypeid]
					WHERE   b.[typeId] <> '00000'
							AND b.[isclient] = 1
							AND b.sonnum = 0
		  ) n 
		  Left JOIN DifAtype ad on ad.Rec = n.DifAType 
		  Left JOIN Dlya dlya on dlya.atypeid = ad.Atype and dlya.vchcode = n.Vchcode
		  GROUP BY n.areatypeid
        
        
        select tmpB.*,tmpZ.total as zoretotal
		INTO #TempDlyArea
		from #TempDlyAreaNoZore tmpB left join #ZoreTotalList tmpZ  on tmpB.areatypeid = tmpZ.areatypeid
        	
		SELECT @saletotal = SUM(TotalFact), @maolitotal = SUM(TotalFact - CostTotal - costtotalgift )FROM #TempDlyArea WHERE @cZTypeID = '00000'  OR areatypeid LIKE @cZTypeID + '%'
                                                                                                                                                                                             
        SELECT  CASE WHEN a.[TypeID] = '' THEN '99999'
                     ELSE a.TypeID
                END AS rtypeid,a.[SonNum], a.UserCode, a.FullName, a.OrderNo, ISNULL(ds.QtyFact, 0) AS QtyFact,
           ISNULL(ds.TotalFact, 0) AS TotalFact, ISNULL(ds.Tax_TotalFact, 0) AS Tax_TotalFact, ISNULL(ds.Qty, 0) AS Qty, ISNULL(ds.Total, 0) AS Total,
           ISNULL(ds.Tax_Total, 0) AS Tax_Total, ISNULL(ds.Qtyback, 0) AS Qtyback, ISNULL(ds.Totalback, 0) AS Totalback,
           ISNULL(ds.Tax_Totalback, 0) AS Tax_Totalback,
           100 * ( CASE WHEN ISNULL(ds.Qty, 0) = 0 THEN 0 ELSE ISNULL(ds.Qtyback, 0) / ISNULL(ds.Qty, 0)END ) AS BackPercent,
           ISNULL(ds.TaxTotal, 0) AS TaxTotal, ISNULL(ds.CostTotal, 0) AS CostTotal, ISNULL(ds.TotalFact, 0) - ISNULL(ds.CostTotal, 0) - ISNULL(ds.costtotalgift,0) AS profittotal, --ë
           CASE WHEN @saletotal > 0 AND ISNULL(ds.TotalFact, 0) <> 0 THEN CAST(dbo.Divide(ISNULL(ds.TotalFact, 0) * 100, @saletotal) AS NUMERIC(38, 2))ELSE 0 END AS salerate, --۱  
           CASE WHEN @maolitotal > 0 AND ISNULL(ds.TotalFact, 0) <> ISNULL(ds.CostTotal, 0) THEN
                     CAST(dbo.Divide(( ISNULL(ds.TotalFact, 0) - ISNULL(ds.CostTotal, 0) - ISNULL(ds.costtotalgift,0)) * 100, @maolitotal) AS NUMERIC(38, 2))
           ELSE      0
           END AS maolirate, --ëױ    
           ISNULL(ds.qtyother, 0) AS qtyother, ISNULL(ds.SaleZQTotal, 0) AS SaleZQTotal, ISNULL(ds.BackZQTotal, 0) AS BackZQTotal,
           ISNULL(ds.FactZQTotal, 0) AS FactZQTotal,
           dbo.Divide(ds.Totalfact, ds.Qtyfact) AS factprice, -- ʵ,  -- Add ysj V21
           dbo.Divide(ds.Tax_Totalfact, ds.Qtyfact) AS facttaxprice, --ʵ˰ ,
           dbo.Divide(ds.SaleZQTotal, ds.Qty) AS SaleZQPrice, -- ǰ
           dbo.Divide(ds.Total, ds.Qty) AS saleprice, -- ۺ󵥼
           dbo.Divide(ds.Tax_Total, ds.Qty) AS taxprice, -- ۺ˰
           dbo.Divide(ds.BackZQTotal, ds.Qtyback) AS BackZQPrice, -- ˻ǰ
           dbo.Divide(ds.Totalback, ds.Qtyback) AS backprice, -- ˻ۺ󵥼
           dbo.Divide(ds.Tax_Totalback, ds.Qtyback) AS backtaxprice, -- ˻˰
           dbo.Divide(ds.FactZQTotal, ds.Qtyfact) AS FactZQPrice, -- ʵǰ
           dbo.Divide(ds.CostTotal, ds.Qtyfact) AS costprice, -- λɱ
           ds.qtygift, -- Ʒ
           ds.costtotalgift, -- Ʒɱ
           dbo.Divide(( ds.Totalfact - ds.CostTotal -ds.costtotalgift ),(ds.qtygift+ds.Qtyfact)) as maoli,-- λë

           CAST(dbo.Divide(( ds.Totalfact - ds.CostTotal - ds.costtotalgift ) * 100, ds.Totalfact) AS NUMERIC(38, 2)) AS rate, --ë  ,-- ë(%)
           ds.qtyothergift,
           ds.zoretotal
        INTO  #TempFinal
        FROM    #AreaType a
        LEFT JOIN #TempDlyArea ds ON ds.areatypeid = a.TypeID 
        WHERE (( ds.[Qty] <> 0 OR ds.[Total] <> 0 OR ds.[Tax_Total] <> 0 OR ds.[TaxTotal] <> 0 OR ds.[CostTotal] <> 0 OR ds.[Qtyback] <> 0 OR ds.[Totalback] <> 0
               OR ds.[Tax_Totalback] <> 0 OR ds.[QtyFact] <> 0 OR ds.[TotalFact] <> 0 OR ds.[Tax_TotalFact] <> 0 OR ds.qtyother <> 0 OR SaleZQTotal <> 0
               OR BackZQTotal <> 0 OR FactZQTotal <> 0 or ds.qtygift <> 0 or ds.qtyothergift <> 0  or ds.costtotalgift <> 0  ) OR @ShowAll = 1 ) 
        IF @IsPaging = 1
           EXEC [P_XIWA_ToPage] '#TempFinal', @PageSize, @PageIndex, @PageFilter, @PageTotal OUTPUT, 'OrderNo,usercode,rtypeid',
                'qty;qtyother;total;tax_total;costtotal;taxtotal;profittotal;rate;qtyback;totalback;tax_totalback;qtyfact;totalfact;tax_totalfact;SaleZQTotal;BackZQTotal;FactZQTotal;qtygift;costtotalgift;qtyothergift;zoretotal;'
        ELSE
          SELECT  *
          FROM    #TempFinal
          ORDER BY OrderNo, UserCode, rtypeid
        
        DROP TABLE #TempDlyArea
        DROP TABLE #TempFinal
        DROP TABLE #TempDlyBtype
 end
 GO


 IF EXISTS ( SELECT  *
            FROM    dbo.sysobjects
            WHERE   id = OBJECT_ID(N'[dbo].[P_XIWA_PSellPHB_AreaType_Ctype]')
                    AND OBJECTPROPERTY(id, N'IsProcedure') = 1 )
  DROP PROCEDURE P_XIWA_PSellPHB_AreaType_Ctype
GO
CREATE  PROCEDURE P_XIWA_PSellPHB_AreaType_Ctype
(   
  @cMode NVARCHAR(1) ,
  @lMode INT ,
  @cZTypeID NVARCHAR(25) ,
  @szptypeid NVARCHAR(50) ,
  @szBEGINDate NVARCHAR(25) ,
  @szEndDate NVARCHAR(25) ,
  @szEtypeid NVARCHAR(60),   -- add V21 ysj
  @szKtypeid NVARCHAR(60),  -- add V21 ysj
  @szBrandTypeid NVARCHAR(60),  -- add V21 ysj
  @OperatorID NVARCHAR(25) ,
  @ShowAll BIT ,
  @IsPaging INT = 0 ,--0Ϊ,1Ϊҳ
  @PageSize INT = 50 ,--ÿҳʾ
  @PageIndex INT = 0 ,--ڼҳ
  @PageFilter NVARCHAR(MAX) = '' ,
  @PageTotal INT = 0 OUTPUT      
 )As
 begin
	SET NOCOUNT ON
	
	DECLARE @Len INT  
	DECLARE @Parid NVARCHAR(100) 
	DECLARE @saletotal NUMERIC(38, 10)
	DECLARE @maolitotal NUMERIC(38, 10)
	
	IF ( @cZTypeID = '' )
		SELECT  @Parid = '00000'
	ELSE
		  SELECT  @Parid = @cZTypeID
	IF ( @cZTypeID = '' )
		  OR ( @cZTypeID = '00000' )
		  BEGIN  
			SELECT  @Len = 5  
			SELECT  @cZTypeID = '%'  
		  END
	ELSE
	  BEGIN  
		SELECT  @Len = LEN(@cZTypeID) + 5  
		SELECT  @cZTypeID = @cZTypeID + '%'     
	  END 
	  
	SELECT  [TypeID], [SonNum], UserCode, FullName, OrderNo
	INTO    #AreaType
	FROM    dbo.AreaType
	WHERE   [ParID] = @Parid
			AND [TypeID] <> '00000'
                    
	IF @Parid = '00000' or @Parid ='99999'
	  INSERT  INTO #AreaType
	  VALUES  ( '', 0, '', '', 99999 )	

	  
	SELECT  PTypeID INTO  #PTypeID FROM dbo.GetUserPrights(@OperatorID)
	SELECT  BTypeID INTO  #BTypeID FROM dbo.GetUserBrights(@OperatorID)
	SELECT  KTypeID INTO  #KTypeID FROM  dbo.GetUserKrights(@OperatorID)
	SELECT  DTypeID INTO  #DTypeID FROM  dbo.GetUserDrights(@OperatorID)
	
	Select s.Vchcode,s.btypeid,s.DetailSign,s.Qty,s.discounttotal,s.tax_total,s.Vchtype,s.total,s.costtotal,s.QtyOther,
		s.PtypeId,s.ktypeid,n.projectid,n.DifAType,s.etypeid
	Into #dlys
	From DlySale s
	INNER JOIN Dlyndx n ON  s.Vchcode = n.Vchcode
	WHERE   n.[DATE] >= @szBEGINDate  AND n.[DATE] <= @szEndDate
	   AND n.draft = 2

 SELECT DS.btypeid, DS.AreaTypeID, DS.QtyFact, DS.TotalFact, DS.Tax_TotalFact, DS.Qty, DS.Total, DS.Tax_Total, DS.Qtyback, DS.Totalback, DS.Tax_Totalback, DS.TaxTotal,
           DS.disTotal, DS.CostTotal, DS.qtyother, DS.SaleZQTotal, DS.BackZQTotal, DS.SaleZQTotal - DS.BackZQTotal AS FactZQTotal,qtygift,costtotalgift,qtyothergift
 INTO #TempDlyBtype
    FROM ( SELECT s.btypeid, 
				  case when b.AreaTypeID ='' then '99999' else b.AreaTypeID end as AreaTypeID,
				  SUM(case when s.DetailSign = 0 then ISNULL(-s.Qty, 0) else 0 end) AS QtyFact, 
				  SUM(ISNULL(-s.discounttotal, 0)) AS TotalFact,
                  SUM(ISNULL(-s.tax_total, 0)) AS Tax_TotalFact,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN case when s.DetailSign = 0 then ISNULL(-s.Qty, 0) else 0 end ELSE 0 END) AS Qty,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.discounttotal, 0)ELSE 0 END) AS Total,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.tax_total, 0)ELSE 0 END) AS Tax_Total,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN case when s.DetailSign = 0 then ISNULL(s.Qty, 0) else 0 end ELSE 0 END) AS Qtyback,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.discounttotal, 0)ELSE 0 END) AS Totalback,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.tax_total, 0)ELSE 0 END) AS Tax_Totalback,
                  SUM(ISNULL(-s.tax_total, 0)) - SUM(ISNULL(-s.discounttotal, 0)) AS TaxTotal,
                  SUM(ISNULL(-s.total, 0)) - SUM(ISNULL(-s.discounttotal, 0)) AS disTotal, --ۿ۽
                  SUM(case when s.DetailSign = 0 then ISNULL(-s.costtotal, 0) else 0 end ) AS CostTotal, 
                  SUM(case when s.DetailSign = 0 then ISNULL(-s.QtyOther, 0) else 0 end) AS qtyother,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END <> 45 THEN ISNULL(-s.total, 0)ELSE 0 END) AS SaleZQTotal,
                  SUM(CASE WHEN CASE WHEN s.Vchtype > 10000 THEN s.Vchtype / 10000 ELSE s.Vchtype END = 45 THEN ISNULL(s.total, 0)ELSE 0 END) AS BackZQTotal,
                  SUM(CASE WHEN s.DetailSign = 1 THEN -s.[Qty] ELSE 0 END) AS qtygift,--Ʒ
				  SUM(CASE WHEN s.DetailSign = 1 THEN -s.[CostTotal] ELSE 0 END) AS costtotalgift,--Ʒɱ			  
				  SUM(CASE WHEN s.DetailSign = 1 THEN -s.QtyOther ELSE 0 END) AS qtyothergift--Ʒλ
           FROM    #dlys s
					INNER JOIN #PTypeID pr ON s.PtypeId = pr.PTypeID
					INNER JOIN #BTypeID br ON s.btypeid = br.BTypeID
					INNER JOIN #KTypeID kr ON s.ktypeid = kr.KTypeID
					INNER JOIN #DTypeID dr ON s.projectid = dr.DTypeID
					left JOIN ptype p on s.PtypeId = p.typeId
					Left JOIN DifAtype ad on ad.Rec = s.DifAType 
					Left JOIN Dlya dlya on dlya.atypeid = ad.Atype and dlya.vchcode = s.Vchcode
					left join Btype b on b.typeId = s.btypeid 
					left join #AreaType at on (at.TypeID = b.AreaTypeID or b.AreaTypeID = '')
           WHERE   ( @szptypeid = '%' OR s.PtypeId LIKE @szptypeid)
				   AND ( @szEtypeid = '%' OR s.etypeid LIKE @szEtypeid)
				   AND ( @szKtypeid = '%' OR s.ktypeid LIKE @szKtypeid)
				   AND ( @szBrandTypeid = '%' OR p.Brandtypeid LIKE @szBrandTypeid)
				   AND ( @cZTypeID = '%' 
                        OR (case when b.AreaTypeID ='' then '99999' else b.AreaTypeID end ) LIKE @cZTypeID )
           GROUP BY s.btypeid,b.AreaTypeID) DS           

	

		SELECT  CASE WHEN b.[AreaTypeID] = '' THEN '99999'
                       ELSE b.[AreaTypeID]
                  END AS [areatypeid], CASE WHEN b.[AreaTypeID] = '' THEN 99999
                                            ELSE b.[OrderNo]
                                       END AS [OrderNo], b.[typeId] AS bctypeid, 
				(DS.QtyFact) as QtyFact,  (DS.TotalFact) as TotalFact, (DS.Tax_TotalFact) as Tax_TotalFact, 
				(DS.Qty) as Qty, (DS.Total) as Total, (DS.Tax_Total) as Tax_Total, (DS.Qtyback) as Qtyback, 
				(DS.Totalback) as Totalback, (DS.Tax_Totalback) as Tax_Totalback, (DS.TaxTotal) as TaxTotal,
                (DS.disTotal) as disTotal, (DS.CostTotal) as CostTotal, (DS.qtyother) AS qtyother, 
                (DS.SaleZQTotal) as SaleZQTotal, (DS.BackZQTotal) AS BackZQTotal, (DS.FactZQTotal) AS FactZQTotal,
                (ds.qtygift) as qtygift,
                (ds.costtotalgift) as costtotalgift,
                (ds.qtyothergift) as qtyothergift
        INTO    #TempDlyBtypeFinishNoZore
        FROM    Btype b
        INNER JOIN #BTypeID br ON  b.typeId = br.BTypeID
        LEFT JOIN #TempDlyBtype ds ON b.[typeId] = ds.[btypeid]
        WHERE   b.[typeId] <> '00000'
                AND b.[isclient] = 1
                AND b.sonnum = 0
              
                 
        select n.areatypeid,n.btypeid, SUM(dlya.total) as total  
		INTO #ZoreTotalList
		from (
			SELECT distinct CASE WHEN b.[AreaTypeID] = '' THEN '99999'
                       ELSE b.[AreaTypeID]
                  END AS [areatypeid], ds.btypeid, ds.Vchcode,ds.DifAType
			   FROM    Btype b
					INNER JOIN #BTypeID br ON  b.typeId = br.BTypeID
					LEFT JOIN (
						SELECT s.btypeid,s.Vchcode,s.DifAType
						   FROM    #dlys s
							INNER JOIN #PTypeID pr ON s.PtypeId = pr.PTypeID
							INNER JOIN #BTypeID br ON s.btypeid = br.BTypeID
							INNER JOIN #KTypeID kr ON s.ktypeid = kr.KTypeID
							INNER JOIN #DTypeID dr ON s.projectid = dr.DTypeID
							left JOIN ptype p on s.PtypeId = p.typeId
				   WHERE   ( @szptypeid = '%' OR s.PtypeId LIKE @szptypeid)
						   AND ( @szEtypeid = '%' OR s.etypeid LIKE @szEtypeid)
						   AND ( @szKtypeid = '%' OR s.ktypeid LIKE @szKtypeid)
						   AND ( @szBrandTypeid = '%' OR p.Brandtypeid LIKE @szBrandTypeid)
					
					) ds ON b.[typeId] = ds.[btypeid]
					 WHERE   b.[typeId] <> '00000'
							AND b.[isclient] = 1
							AND b.sonnum = 0
							AND ( @cZTypeID = '%'
									OR (CASE WHEN b.[AreaTypeID] = '' THEN '99999'
                       ELSE b.[AreaTypeID] end) LIKE @cZTypeID )
		  ) n 
		  Left JOIN DifAtype ad on ad.Rec = n.DifAType 
		  Left JOIN Dlya dlya on dlya.atypeid = ad.Atype and dlya.vchcode = n.Vchcode
		  GROUP BY n.areatypeid,n.btypeid
        
  
        select tmpB.*,tmpZ.total as zoretotal
		INTO #TempDlyBtypeFinish
		from #TempDlyBtypeFinishNoZore tmpB left join #ZoreTotalList tmpZ  on tmpB.areatypeid = tmpZ.areatypeid and tmpB.bctypeid = tmpZ.btypeid
			
        
		SELECT @saletotal = SUM(TotalFact), @maolitotal = SUM(TotalFact - CostTotal- costtotalgift)FROM #TempDlyBtypeFinish WHERE @cZTypeID = '00000' OR areatypeid LIKE @cZTypeID + '%' 
                                             
                                                                                                                                                                                                                  
        SELECT  CASE WHEN b.[TypeID] = '' THEN '99999'
                     ELSE b.TypeID
                END AS bctypeid,b.[SonNum], b.UserCode, b.FullName, b.OrderNo, ISNULL(ds.QtyFact, 0) AS QtyFact,
           ISNULL(ds.TotalFact, 0) AS TotalFact, ISNULL(ds.Tax_TotalFact, 0) AS Tax_TotalFact, ISNULL(ds.Qty, 0) AS Qty, ISNULL(ds.Total, 0) AS Total,
           ISNULL(ds.Tax_Total, 0) AS Tax_Total, ISNULL(ds.Qtyback, 0) AS Qtyback, ISNULL(ds.Totalback, 0) AS Totalback,
           ISNULL(ds.Tax_Totalback, 0) AS Tax_Totalback,
           100 * ( CASE WHEN ISNULL(ds.Qty, 0) = 0 THEN 0 ELSE ISNULL(ds.Qtyback, 0) / ISNULL(ds.Qty, 0)END ) AS BackPercent,
           ISNULL(ds.TaxTotal, 0) AS TaxTotal, ISNULL(ds.CostTotal, 0) AS CostTotal, ISNULL(ds.TotalFact, 0) - ISNULL(ds.CostTotal, 0) - ISNULL(ds.costtotalgift,0) AS profittotal, --ë
           CASE WHEN @saletotal > 0 AND ISNULL(ds.TotalFact, 0) <> 0 THEN CAST(dbo.Divide(ISNULL(ds.TotalFact, 0) * 100, @saletotal) AS NUMERIC(38, 2))ELSE 0 END AS salerate, --۱  
           CASE WHEN @maolitotal > 0 AND ISNULL(ds.TotalFact, 0) <> ISNULL(ds.CostTotal, 0) THEN
                     CAST(dbo.Divide(( ISNULL(ds.TotalFact, 0) - ISNULL(ds.CostTotal, 0) - ISNULL(ds.costtotalgift,0) ) * 100, @maolitotal) AS NUMERIC(38, 2))
           ELSE      0
           END AS maolirate, --ëױ    
           ISNULL(ds.qtyother, 0) AS qtyother, ISNULL(ds.SaleZQTotal, 0) AS SaleZQTotal, ISNULL(ds.BackZQTotal, 0) AS BackZQTotal,
           ISNULL(ds.FactZQTotal, 0) AS FactZQTotal,
           dbo.Divide(ds.Totalfact, ds.Qtyfact) AS factprice, -- ʵ,  -- Add ysj V21
           dbo.Divide(ds.Tax_Totalfact, ds.Qtyfact) AS facttaxprice, --ʵ˰ ,
           dbo.Divide(ds.SaleZQTotal, ds.Qty) AS SaleZQPrice, -- ǰ
           dbo.Divide(ds.Total, ds.Qty) AS saleprice, -- ۺ󵥼
           dbo.Divide(ds.Tax_Total, ds.Qty) AS taxprice, -- ۺ˰
           dbo.Divide(ds.BackZQTotal, ds.Qtyback) AS BackZQPrice, -- ˻ǰ
           dbo.Divide(ds.Totalback, ds.Qtyback) AS backprice, -- ˻ۺ󵥼
           dbo.Divide(ds.Tax_Totalback, ds.Qtyback) AS backtaxprice, -- ˻˰
           dbo.Divide(ds.FactZQTotal, ds.Qtyfact) AS FactZQPrice, -- ʵǰ
           dbo.Divide(ds.CostTotal, ds.Qtyfact) AS costprice, -- λɱ
           ds.qtygift, -- Ʒ
           ds.costtotalgift, -- Ʒɱ
           dbo.Divide(( ds.Totalfact - ds.CostTotal - ds.costtotalgift ),(ds.qtygift+ds.Qtyfact)) as maoli,-- λë
           CAST(dbo.Divide(( ds.Totalfact - ds.CostTotal- ds.costtotalgift ) * 100, ds.Totalfact) AS NUMERIC(38, 2)) AS rate, --ë  ,-- ë(%)
           ds.qtyothergift,
           ds.zoretotal  
        INTO  #TempFinal
        FROM  #TempDlyBtypeFinish ds
        INNER JOIN Btype b ON  ds.bctypeid = b.typeId
        WHERE (( ds.[Qty] <> 0 OR ds.[Total] <> 0 OR ds.[Tax_Total] <> 0 OR ds.[TaxTotal] <> 0 OR ds.[CostTotal] <> 0 OR ds.[Qtyback] <> 0 OR ds.[Totalback] <> 0
               OR ds.[Tax_Totalback] <> 0 OR ds.[QtyFact] <> 0 OR ds.[TotalFact] <> 0 OR ds.[Tax_TotalFact] <> 0 OR ds.qtyother <> 0 OR SaleZQTotal <> 0
               OR BackZQTotal <> 0 OR FactZQTotal <> 0 or ds.qtygift <> 0 or ds.qtyothergift <> 0  or ds.costtotalgift <> 0  ) OR @ShowAll = 1 ) 
        IF @IsPaging = 1
           EXEC [P_XIWA_ToPage] '#TempFinal', @PageSize, @PageIndex, @PageFilter, @PageTotal OUTPUT, 'OrderNo,usercode,bctypeid',
                'qty;qtyother;total;tax_total;costtotal;taxtotal;profittotal;rate;qtyback;totalback;tax_totalback;qtyfact;totalfact;tax_totalfact;SaleZQTotal;BackZQTotal;FactZQTotal;qtygift;costtotalgift;qtyothergift;zoretotal;'
        ELSE
          SELECT  *
          FROM    #TempFinal
          ORDER BY OrderNo, UserCode, bctypeid
        
        DROP TABLE #TempDlyBtype
        DROP TABLE #TempDlyBtypeFinish
        DROP TABLE #TempFinal
        
 end
 GO


 IF EXISTS ( SELECT  *
            FROM    dbo.sysobjects
            WHERE   id = OBJECT_ID(N'[dbo].[P_XIWA_PSellPHBList_AreaType]')
                    AND OBJECTPROPERTY(id, N'IsProcedure') = 1 )
  DROP PROCEDURE P_XIWA_PSellPHBList_AreaType
GO
CREATE  PROCEDURE P_XIWA_PSellPHBList_AreaType
(   
  @cMode NVARCHAR(1) ,
  @lMode INT ,
  @cZTypeID NVARCHAR(25) ,
  @szptypeid NVARCHAR(50) ,
  @szBEGINDate NVARCHAR(25) ,
  @szEndDate NVARCHAR(25) ,
  @szEtypeid NVARCHAR(60),   -- add V21 ysj
  @szKtypeid NVARCHAR(60),  -- add V21 ysj
  @szBrandTypeid NVARCHAR(60),  -- add V21 ysj
  @OperatorID NVARCHAR(25) ,
  @ShowAll BIT ,
  @IsPaging INT = 0 ,--0Ϊ,1Ϊҳ
  @PageSize INT = 50 ,--ÿҳʾ
  @PageIndex INT = 0 ,--ڼҳ
  @PageFilter NVARCHAR(MAX) = '' ,
  @PageTotal INT = 0 OUTPUT     
 )As
 begin
	SET NOCOUNT ON
	DECLARE @Len INT  
	DECLARE @Parid NVARCHAR(100) 
	DECLARE @saletotal NUMERIC(38, 10)
	DECLARE @maolitotal NUMERIC(38, 10)
	IF ( @cZTypeID = '' )
		SELECT  @Parid = '00000'
	ELSE
		  SELECT  @Parid = @cZTypeID
	IF ( @cZTypeID = '' )
		  OR ( @cZTypeID = '00000' )
		  BEGIN  
			SELECT  @Len = 5  
			SELECT  @cZTypeID = '%'  
		  END
	ELSE
	  BEGIN  
		SELECT  @Len = LEN(@cZTypeID) + 5  
		SELECT  @cZTypeID = @cZTypeID + '%'     
	  END 
        
	--SELECT  PTypeID INTO  #PTypeID FROM dbo.GetUserPrights(@OperatorID)
	SELECT  BTypeID INTO  #BTypeID FROM dbo.GetUserBrights(@OperatorID)
	SELECT  KTypeID INTO  #KTypeID FROM  dbo.GetUserKrights(@OperatorID) Where (@szKtypeid = '%' OR KTypeID LIKE @szKtypeid)
	SELECT  DTypeID INTO  #DTypeID FROM  dbo.GetUserDrights(@OperatorID)

	Select * 
	Into #Prights
	From dbo.GetUserHasRightsP(@OperatorID) p
	Where p.brandtypeid LIKE @szBrandTypeid + '%'
		And (@szPtypeid = '%' OR p.typeId LIKE @szPtypeid)


	SELECT  [TypeID], [SonNum], UserCode, FullName, OrderNo
	INTO    #AreaTypeList
	FROM    dbo.AreaType
	WHERE   [TypeID] <> '00000'  AND (@cZTypeID = '%' OR typeId LIKE @cZTypeID) AND [sonnum] = 0
	                    
	IF @cZTypeID = '%'
	  INSERT  INTO #AreaTypeList
	  VALUES  ( '', 0, '', '', 99999 )

	Select s.[Qty] AS [Qty], s.[discountTotal] AS [discountTotal], s.[Tax_Total] AS [Tax_Total],
			s.[TaxTotal] AS [TaxTotal], s.[costtotal] AS [costtotal], s.btypeid AS btypeid,d.Vchtype,d.Vchcode, s.QtyOther,
			s.total,s.DetailSign,s.PtypeId,s.ktypeid,d.projectid,d.DifAType,s.etypeid
	Into #dlySale
	From DlySale s 
	INNER JOIN Dlyndx d ON  s.Vchcode = d.Vchcode
	WHERE d.Draft = 2
		AND d.[date] >= @szBeginDate
		AND d.[date] <= @szEndDate
	  

    SELECT s.[Qty] AS [Qty], s.[discountTotal] AS [discountTotal], s.[Tax_Total] AS [Tax_Total],
			s.[TaxTotal] AS [TaxTotal], s.[costtotal] AS [costtotal], s.btypeid AS btypeid,s.Vchtype,s.Vchcode, s.QtyOther,
			s.total,s.DetailSign,
			row_number() over(partition by s.btypeid,s.vchcode order by s.btypeid,s.vchcode) as RowNo
    INTO #TempDlyBtypeList
    FROM #dlySale s
	INNER JOIN #Prights pr ON s.PtypeId = pr.typeId
	INNER JOIN #BTypeID br ON s.btypeid = br.BTypeID
	INNER JOIN #KTypeID kr ON s.ktypeid = kr.KTypeID
	INNER JOIN #DTypeID dr ON s.projectid = dr.DTypeID
	--left JOIN ptype p on s.PtypeId = p.typeId
	--Left JOIN DifAtype ad on ad.Rec = d.DifAType 
	--Left JOIN Dlya dlya on dlya.atypeid = ad.Atype and dlya.vchcode = d.Vchcode
    WHERE (@szEtypeid = '%' OR s.etypeid LIKE @szEtypeid)
		--AND (@szKtypeid = '%' OR s.ktypeid LIKE @szKtypeid)
		--AND (@szBrandTypeid = '%' OR p.Brandtypeid LIKE @szBrandTypeid)
		

	    SELECT  b.AreaTypeID AS areatypeid, 
				d.[Qty] AS [Qty], d.[discountTotal] AS [discountTotal], d.[Tax_Total] AS [Tax_Total],
			d.[TaxTotal] AS [TaxTotal], d.[costtotal] AS [costtotal], d.[btypeid] AS [btypeid],d.Vchtype,d.Vchcode, d.QtyOther,
			d.total,d.DetailSign,d.RowNo
        INTO    #TempDlyAreaListNoZore
        FROM    Btype b
        INNER JOIN #BTypeID br ON  b.typeId = br.BTypeID
        LEFT JOIN #TempDlyBtypeList d ON b.[typeId] = d.[btypeid]
        WHERE   b.[typeId] <> '00000'
                AND b.[isclient] = 1
                AND b.sonnum = 0
                
                
       SELECT  b.AreaTypeID AS areatypeid,d.Vchtype,d.Vchcode,
			d.zoretotal as zoretotal
			into #ZoreTotalList
        FROM    Btype b
        INNER JOIN #BTypeID br ON  b.typeId = br.BTypeID
        LEFT JOIN (
			SELECT distinct s.btypeid AS btypeid,d.Vchtype,d.Vchcode,ISNULL(dlya.total,0) as zoretotal
			FROM DlySale s 
			INNER JOIN Dlyndx d ON  s.Vchcode = d.Vchcode
			INNER JOIN #Prights pr ON s.PtypeId = pr.typeId
			INNER JOIN #BTypeID br ON s.btypeid = br.BTypeID
			INNER JOIN #KTypeID kr ON s.ktypeid = kr.KTypeID
			INNER JOIN #DTypeID dr ON d.projectid = dr.DTypeID
			left JOIN ptype p on s.PtypeId = p.typeId
			Left JOIN DifAtype ad on ad.Rec = d.DifAType 
			Left JOIN Dlya dlya on dlya.atypeid = ad.Atype and dlya.vchcode = d.Vchcode
			WHERE d.Draft = 2
				AND d.[date] >= @szBeginDate
				AND d.[date] <= @szEndDate
				--AND (@szPtypeid = '%' OR s.[ptypeid] LIKE @szPtypeid)
				AND (@szEtypeid = '%' OR s.etypeid LIKE @szEtypeid)
				AND (@szKtypeid = '%' OR s.ktypeid LIKE @szKtypeid)
				--AND (@szBrandTypeid = '%' OR p.Brandtypeid LIKE @szBrandTypeid)
        ) d ON b.[typeId] = d.[btypeid]
        WHERE   b.[typeId] <> '00000'
                AND b.[isclient] = 1
                AND b.sonnum = 0		
	   
	   select areatypeid,Vchtype,Vchcode,SUM(zoretotal) as zoretotal 
		into #ZoreTotalListSum
		from  #ZoreTotalList group by areatypeid,Vchtype,Vchcode
	      
   
       select tab.* 
		into #TempDlyAreaList
		from (   
			select tb.*,tz.zoretotal from #TempDlyAreaListNoZore tb left join  #ZoreTotalListSum tz on tb.areatypeid= tz.areatypeid and tb.Vchtype = tz.Vchtype and tb.Vchcode = tz.Vchcode where tb.RowNo = 1
			UNION ALL
			select tb.*,0 as zoretotal from #TempDlyAreaListNoZore tb left join  #ZoreTotalListSum tz on tb.areatypeid= tz.areatypeid and tb.Vchtype = tz.Vchtype and tb.Vchcode = tz.Vchcode where tb.RowNo <> 1
		) tab
		 
		SELECT @saletotal = -SUM([discountTotal]), @maolitotal = -SUM([discountTotal] - CostTotal) FROM #TempDlyAreaList 

			
		SELECT *,Rs.SaleZQTotal - Rs.BackZQTotal AS FactZQTotal , 
        100 * ( CASE WHEN Rs.Qty = 0 THEN 0 ELSE Rs.Qtyback / Rs.Qty  END ) AS backpercent,       
        dbo.Divide(Rs.Totalfact, Rs.Qtyfact) AS factprice, -- ʵ,  -- Add ysj V21
        dbo.Divide(Rs.Tax_Totalfact, Rs.Qtyfact) AS facttaxprice, --ʵ˰ ,
        dbo.Divide(Rs.SaleZQTotal, Rs.Qty) AS SaleZQPrice, -- ǰ
        dbo.Divide(Rs.Total, Rs.Qty) AS saleprice, -- ۺ󵥼
        dbo.Divide(Rs.Tax_Total, Rs.Qty) AS taxprice, -- ۺ˰
        dbo.Divide(Rs.BackZQTotal, Rs.Qtyback) AS BackZQPrice, -- ˻ǰ
        dbo.Divide(Rs.Totalback, Rs.Qtyback) AS backprice, -- ˻ۺ󵥼
        dbo.Divide(Rs.Tax_Totalback, Rs.Qtyback) AS backtaxprice, -- ˻˰
        dbo.Divide((Rs.SaleZQTotal - Rs.BackZQTotal), Rs.Qtyfact) AS FactZQPrice, -- ʵǰ
        dbo.Divide(Rs.CostTotal, Rs.Qtyfact) AS costprice, -- λɱ
        dbo.Divide(( Rs.Totalfact - Rs.CostTotal-Rs.costtotalgift ),(Rs.qtygift+Rs.Qtyfact)) as maoli,-- λë
        CAST(dbo.Divide(( Rs.Totalfact - Rs.CostTotal- Rs.costtotalgift ) * 100, Rs.Totalfact) AS NUMERIC(38, 2)) AS rate, --ë  ,-- ë(%)
        CASE WHEN @saletotal > 0
                  AND TotalFact <> 0 THEN CAST(dbo.Divide(TotalFact * 100, @saletotal) AS NUMERIC(38, 2))
             ELSE 0
        END AS salerate ,
       
        CASE WHEN @maolitotal > 0
                  AND TotalFact <> CostTotal
             THEN CAST(dbo.Divide(( TotalFact - CostTotal - costtotalgift ) * 100, @maolitotal) AS NUMERIC(38, 2))
             ELSE 0
        END AS maolirate         --ëױ
    INTO #TempFinalList
    FROM
	(
		SELECT CASE WHEN a.[TypeID] = '' THEN '99999'
                     ELSE a.TypeID END AS rtypeid, a.UserCode, a.OrderNo,
			-SUM(case when b.DetailSign = 0 then b.Qty else 0 end) AS Qtyfact,
			-SUM(b.discountTotal) AS TotalFact,
			-SUM(b.Tax_Total) AS Tax_TotalFact,
			-SUM(CASE WHEN case When Vchtype > 10000 Then Vchtype / 10000 else Vchtype end <> 45 THEN case when b.DetailSign = 0 then b.[Qty] else 0 end  ELSE 0 END) AS Qty, 
			-SUM(CASE WHEN case When Vchtype > 10000 Then Vchtype / 10000 else Vchtype end <> 45 THEN b.[discountTotal] ELSE 0 END) AS Total, 
			-SUM(CASE WHEN case When Vchtype > 10000 Then Vchtype / 10000 else Vchtype end <> 45 THEN b.[Tax_Total] ELSE 0 END) AS Tax_Total,
			SUM(CASE WHEN case When Vchtype > 10000 Then Vchtype / 10000 else Vchtype end = 45 THEN  case when b.DetailSign = 0 then b.[Qty] else 0 end  ELSE 0 END) AS Qtyback,
			SUM(CASE WHEN case When Vchtype > 10000 Then Vchtype / 10000 else Vchtype end = 45 THEN b.[discountTotal] ELSE 0 END) AS Totalback, 
			SUM(CASE WHEN case When Vchtype > 10000 Then Vchtype / 10000 else Vchtype end = 45 THEN b.[Tax_Total] ELSE 0 END) AS Tax_Totalback,
			-SUM(b.[Tax_Total]) + SUM(b.[discountTotal]) AS TaxTotal,
			-SUM( case when b.DetailSign = 0 then b.[costtotal] else 0 end) AS CostTotal,
			(-SUM(discountTotal) + SUM(costtotal)) AS profittotal,							--ë
			-SUM( case when b.DetailSign = 0 then b.QtyOther else 0 end ) AS QtyOther,
			SUM(CASE WHEN case When b.Vchtype > 10000 Then b.Vchtype / 10000 else b.Vchtype end <> 45 THEN ISNULL(-b.[Total], 0) ELSE 0 END) AS SaleZQTotal,
			SUM(CASE WHEN case When b.Vchtype > 10000 Then b.Vchtype / 10000 else b.Vchtype end = 45 THEN ISNULL(b.[Total], 0) ELSE 0 END) AS BackZQTotal,
			SUM(CASE WHEN b.DetailSign = 1 THEN -b.[Qty] ELSE 0 END) AS qtygift,--Ʒ
			SUM(CASE WHEN b.DetailSign = 1 THEN -b.[CostTotal] ELSE 0 END) AS costtotalgift,--Ʒɱ			  
			SUM(CASE WHEN b.DetailSign = 1 THEN -b.QtyOther ELSE 0 END) AS qtyothergift,--Ʒλ
			SUM(b.zoretotal) as zoretotal
		FROM #AreaTypeList a
			left JOIN #TempDlyAreaList AS b ON b.areatypeid = a.TypeID 
		GROUP BY a.[typeid], a.[usercode], a.[OrderNo]
	) Rs
    WHERE NOT (Rs.Qty = 0 AND Rs.Total = 0 AND Rs.Tax_Total = 0 AND Rs.TaxTotal = 0 AND Rs.costtotal = 0
    AND Rs.Qtyfact = 0 AND Rs.Totalfact = 0 AND Rs.Tax_Totalfact = 0
    AND Rs.Qtyback = 0 AND Rs.Totalback = 0 AND Rs.Tax_Totalback = 0 AND Rs.QtyOther = 0
    AND Rs.SaleZQTotal = 0 AND Rs.BackZQTotal=0 and rs.qtyothergift = 0 and rs.qtygift = 0 and rs.costtotalgift = 0)

        IF @IsPaging = 1
           EXEC [P_XIWA_ToPage] '#TempFinalList', @PageSize, @PageIndex, @PageFilter, @PageTotal OUTPUT, 'OrderNo,usercode,rtypeid',
                'qty;qtyother;total;tax_total;costtotal;taxtotal;profittotal;rate;qtyback;totalback;tax_totalback;qtyfact;totalfact;tax_totalfact;SaleZQTotal;BackZQTotal;FactZQTotal;qtygift;costtotalgift;qtyothergift;zoretotal;'
        ELSE
          SELECT  *
          FROM    #TempFinalList
          ORDER BY OrderNo, UserCode, rtypeid
        DROP TABLE #TempDlyAreaList
        DROP TABLE #TempFinalList
        DROP TABLE #AreaTypeList
        DROP TABLE #ZoreTotalListSum
 end
 GO