/****** Object:  StoredProcedure [dbo].[P_XIWA_VchOrderQuery_Query]    Script Date: 2025-10-28 14:18:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER OFF
GO
ALTER   PROCEDURE [dbo].[P_XIWA_VchOrderQuery_Query]
(
  @cMode NVARCHAR(1) ,
  @lMode INT ,
  @szNeedCheck INT ,
  @szBtypeID NVARCHAR(50) ,
  @szEtypeID NVARCHAR(50) ,
  @szMtypeID NVARCHAR(50) ,
  @Custom01 NVARCHAR(60) ,--ͷԶ1	|
  @Custom02 NVARCHAR(60) ,--ͷԶ2	|Add by wyli 2011-03-04
  @Custom03 NVARCHAR(60) ,--ͷԶ3	|
  @szBeginDate NVARCHAR(10) ,
  @szEndDate NVARCHAR(10) ,
  @Custom1 NVARCHAR(10) ,
  @OperatorID NVARCHAR(50) ,
  @IsPaging INT = 0 ,--0Ϊ,1Ϊҳ
  @PageSize INT = 50 ,--ÿҳʾ
  @PageIndex INT = 0 ,--ڼҳ
  @PageFilter NVARCHAR(MAX) = '' ,
  @PageTotal INT = 0 OUTPUT  ,
  @lVchType INT   
 )
AS
BEGIN
  SET NOCOUNT ON
  SELECT BTypeID
  INTO #BTypeID
  FROM   dbo.GetUserBrights(@OperatorID)
  
  SELECT KTypeID
  INTO #KTypeID
  FROM   dbo.GetUserKrights(@OperatorID)
  
  SELECT DTypeID INTO #Drights FROM dbo.GetUserDrights(@OperatorID)	
  
  SELECT  O.[Date], O.Number, O.summary, O.[todate], O.[Vchcode], ISNULL(E.typeId, '') AS etypeid, O.InputNo, O.deposit,
          CASE UPPER(@cMode) WHEN 'I' THEN ISNULL(B.typeId, '') ELSE '' END AS bvtypeid, 
          CASE UPPER(@cMode) WHEN 'S' THEN ISNULL(B.typeId, '') ELSE '' END AS bctypeid, 
          O.[userover], O.[orderover], O.UserDefined01, O.UserDefined02,
          O.UserDefined03, O.UserDefined04, O.UserDefined05, O.UserDefined06, O.UserDefined07, O.UserDefined08,
          O.UserDefined09, O.UserDefined10, O.UserDefined11, O.UserDefined12, O.UserDefined13, O.UserDefined14,
          O.UserDefined15, ISNULL(pc.PrintCount,0) AS UserDefined16,O.mtypeid,O.ProjectID as dtypeid, O.ktypeid
  INTO    #dly
  FROM    DlyndxOrder O
  LEFT JOIN Employee E ON      O.etypeid = E.typeId
  LEFT JOIN Btype B ON      O.btypeid = B.typeId
  INNER JOIN #BTypeID br ON	  O.btypeid = br.BTypeID
  INNER JOIN #KTypeID kr ON	  O.ktypeid = kr.KTypeID
  INNER JOIN #Drights dr on dr.DTypeID = o.ProjectID
  LEFT JOIN dbo.T_Bill_PrintCount pc ON pc.VchCode = O.Vchcode AND pc.VchType = O.VchType
  WHERE   case When o.Vchtype > 10000 Then o.Vchtype / 10000 else o.Vchtype end = @lVchType
  
          AND O.draft <> 4
          AND O.[Date] >= @szBeginDate
          AND O.[Date] <= @szEndDate
          AND ( @Custom1 = ''
                OR O.[todate] <= @Custom1 )
          AND ( @szEtypeID = '%'
                OR O.[etypeid] LIKE @szEtypeID )
          and (@szMtypeID='%' or o.mtypeid like @szMtypeID)
          AND ( @szBtypeID = '%'
                OR O.[btypeid] LIKE @szBtypeID )
          AND ( @lMode = 0 OR (@lMode = 1 AND (O.orderover = 1 OR o.userover = 1)) OR (@lMode = 2 AND O.orderover = 0 AND o.userover = 0))
          AND ( @lVchType = 151
                OR CASE WHEN @szNeedCheck = 0 THEN @szNeedCheck
                        WHEN @szNeedCheck = 1 THEN O.IsQMCheck
                        ELSE O.IsQMCheck + 2
                   END = @szNeedCheck )
  SELECT  d.[Date], d.Number, d.summary, d.[todate], d.[Vchcode], d.bvtypeid, d.bctypeid, d.etypeid,
          CASE d.[orderover] WHEN 1 THEN '' ELSE '' END AS [OrderOver], 
          CASE d.[userover] WHEN 1 THEN '' ELSE '' END AS UserOver, 
          CASE d.[userover] WHEN 1 THEN 'T' ELSE 'F' END AS UserDoOver, 
          ISNULL(SUM(b.discounttotal), 0) AS total,
          ISNULL(SUM(b.tax_total), 0) AS tax_total, d.UserDefined01, d.UserDefined02, d.UserDefined03, d.UserDefined04,
          d.UserDefined05, d.UserDefined06, d.UserDefined07, d.UserDefined08, d.UserDefined09, d.UserDefined10,
          d.UserDefined11, d.UserDefined12, d.UserDefined13, d.UserDefined14, d.UserDefined15, d.UserDefined16,
          b.Vchtype, E.UserCode AS eusercode, E.FullName AS efullname,
          d.InputNo AS replaceFullName, d.InputNo, d.deposit, d.mtypeid,d.dtypeid,d.ktypeid
  INTO    #temp
  FROM    #dly d
  LEFT JOIN BakDlyOrder b ON      d.Vchcode = b.Vchcode
  LEFT JOIN Employee E ON      d.InputNo = E.typeId
  WHERE   b.Draft = 2
          AND ( @Custom01 = '%'
                OR d.UserDefined01 LIKE @Custom01 )
          AND ( @Custom02 = '%'
                OR d.UserDefined02 LIKE @Custom02 )
          AND ( @Custom03 = '%'
                OR d.UserDefined03 LIKE @Custom03 )
  GROUP BY d.[Date], d.Number, d.summary, d.[todate], d.[Vchcode], d.[userover], [OrderOver], d.bvtypeid, d.bctypeid,
          d.etypeid, d.UserDefined01, d.UserDefined02, d.UserDefined03, d.UserDefined04, d.UserDefined05,
          d.UserDefined06, d.UserDefined07, d.UserDefined08, d.UserDefined09, d.UserDefined10, d.UserDefined11,
          d.UserDefined12, d.UserDefined13, d.UserDefined14, d.UserDefined15, d.UserDefined16, b.Vchtype, E.UserCode,
          E.FullName, d.InputNo,d.mtypeid,d.dtypeid,d.ktypeid,d.deposit
          
  IF @IsPaging = 1
    EXEC [P_XIWA_ToPage] '#Temp', @PageSize, @PageIndex, @PageFilter, @PageTotal OUTPUT, 'date,vchcode',
      'total;tax_total;deposit;UserDefined14;UserDefined15;UserDefined16'
  ELSE
    SELECT  *
    FROM    #temp
    ORDER BY Date, Vchcode
  
  DROP TABLE #dly
END
GO